dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/island", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 2, 185, 400, "assets/images/table/island_2", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 3, 365, 400, "assets/images/table/island", "assets/images/food/item_mark1", "B" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1
guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 6, 3000);


-- Group 2


guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestMusic = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male04;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 9, 26000);

-- Group 3


guest = LManager.GenGuest(male01);
guest.matchType = female03;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 10, 64000);


-- Group 4

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 13, 90000);

-- Group 5

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 17, 110000);


-- Group 5

guest = LManager.GenGuest(female02);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 21, 140000);

LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("bridesmaidsDelay", 85000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:SetLevelSetting ("speakerDelay", 120000); 
LManager:SetLevelSetting ("speakerChance", 100);

-- Set up the Level Settings
LManager:SetLevelNumber(4,2);
LManager:SetLevelScores(9000, 12000);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Disco Dance 1.ogg","assets/audio/music/new_dance_4.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );